#ifndef __CSubMenuMenuItem__
#define __CSubMenuMenuItem__

#include "CMenu.hpp"
#include "CMenuItem.hpp"

//	===========================================================================

using Exponent::GUI::Controls::CMenu;
using Exponent::GUI::Controls::CMenuItem;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Controls
		{
			/**
			 * @class CSubMenuMenuItem CSubMenuMenuItem.hpp
			 * @brief A representation of a menu item that can be have a submenu
			 *
			 * @date 12/04/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CSubMenuMenuItem.hpp,v 1.6 2007/02/08 21:07:54 paul Exp $
			 */
			class CSubMenuMenuItem : public CMenuItem
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================

			public:

//	===========================================================================
				
				/**
				 * Construction
				 * @param text The text to display
				 * @param id The id of the menu item
				 */
				CSubMenuMenuItem(const CString &text, const long id);

				/**
				 * Destruction
				 */
				virtual ~CSubMenuMenuItem();

//	===========================================================================
				
				/**
				 * Get the sub menu -> which lets you do anything you want to the sub menu..
				 * @retval CMenu* The sub menu. Will always be valid, but may have no entries
				 */
				virtual CMenu *getMutableSubMenu() const { return m_menu; }

				/**
				 * Get the sub menu
				 * @retval const CMenu* The sub menu. Will always be valid, but may have no entries
				 */
				virtual const CMenu *getSubMenu() const { return m_menu; }

//	===========================================================================
				
			protected:

//	===========================================================================

				CMenu *m_menu;			/**< The sub menus */
			};
		}
	}
}
#endif	// End of CSubMenuMenuItem.hpp